import 'dart:convert';
import 'package:play_lab/data/model/global/global_meassage.dart';
import 'package:play_lab/data/model/live_tv/live_tv_comments_response_model.dart';

TournamentLiveCommentResponseModel tournamentLiveCommentResponseModelFromJson(String str) => TournamentLiveCommentResponseModel.fromJson(json.decode(str));

String tournamentLiveCommentResponseModelToJson(TournamentLiveCommentResponseModel data) => json.encode(data.toJson());

class TournamentLiveCommentResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  TournamentLiveCommentResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory TournamentLiveCommentResponseModel.fromJson(Map<String, dynamic> json) => TournamentLiveCommentResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  List<LiveChatCommentModel>? comments;

  Data({
    this.comments,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        comments: json["comments"] == null ? [] : List<LiveChatCommentModel>.from(json["comments"]!.map((x) => LiveChatCommentModel.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "comments": comments == null ? [] : List<dynamic>.from(comments!.map((x) => x.toJson())),
      };
}
